#ifndef __IKeyboardListener__
#define __IKeyboardListener__

#include "../Events/CKeyboardEvent.hpp"
using Exponent::GUI::Events::CKeyboardEvent;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Listeners
		{
			/**
			 * @interface IKeyboardListener IKeyboardListener.hpp
			 * @brief Allows for responding to keyboard actions
			 *
			 * @date 21/08/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: IKeyboardListener.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			interface IKeyboardListener
			{

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 */
				IKeyboardListener() { }
				
				/**
				 * Destruction
				 */
				virtual ~IKeyboardListener() { }

//	===========================================================================

				/**
				 * Handle key down events
				 * @param event The event to handle
				 * @retval bool True if you handled the event, false otherwise
				 */
				virtual bool handleKeyDown(const CKeyboardEvent &event) = 0;
				
				/**
				 * Handle key up events
				 * @param event The event to handle
				 * @retval bool True if you handled the event, false otherwise
				 */
				virtual bool handleKeyUp(const CKeyboardEvent &event) = 0;

//	===========================================================================
			};
		}
	}
}
#endif	// End of IKeyboardListener.hpp